# Environment Configuration Setup

## Creating .env File

For production deployment, create a `.env` file in the project root with the following content:

```env
# Database Configuration
DB_HOST=localhost:3306
DB_USER=root
DB_PASSWORD=your_secure_password_here
DB_NAME=masunzu_bar_hotel
DB_SOCKET=/opt/lampp/var/mysql/mysql.sock
```

## Steps

1. Copy the template below to create `.env`:
   ```bash
   cd /opt/lampp/htdocs/masunzu_bar_hotel
   cat > .env << 'EOF'
   DB_HOST=localhost:3306
   DB_USER=root
   DB_PASSWORD=@Mysql-x45#
   DB_NAME=masunzu_bar_hotel
   DB_SOCKET=/opt/lampp/var/mysql/mysql.sock
   EOF
   ```

2. **IMPORTANT:** Update `DB_PASSWORD` with your actual secure database password

3. Set proper permissions (readable only by web server):
   ```bash
   chmod 600 .env
   chown www-data:www-data .env  # Adjust user/group as needed
   ```

4. Verify `.env` is in `.gitignore` (already configured)

## Security Notes

- The `.env` file is excluded from version control
- Never commit `.env` to Git
- Use strong passwords in production
- Restrict file permissions to web server user only

## Fallback Behavior

If `.env` file doesn't exist, the system will:
1. Try to read from environment variables (`getenv()`)
2. Fall back to default values (for development only)

**For production, always use `.env` file with secure credentials.**










