-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Dec 13, 2025 at 11:38 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `masunzu_bar_hotel`
--

-- --------------------------------------------------------

--
-- Table structure for table `accountant_balance`
--

CREATE TABLE `accountant_balance` (
  `id` int(11) NOT NULL,
  `accountant_id` int(11) NOT NULL,
  `balance` bigint(20) NOT NULL DEFAULT 0,
  `currency` enum('BIF') NOT NULL DEFAULT 'BIF',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `accountant_balance`
--

-- --------------------------------------------------------

--
-- Table structure for table `audit_log`
--

CREATE TABLE `audit_log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `table_name` varchar(50) NOT NULL,
  `record_id` int(11) DEFAULT NULL,
  `timestamp` datetime DEFAULT current_timestamp(),
  `details` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `audit_log`
--

-- --------------------------------------------------------

--
-- Table structure for table `bank_account`
--

CREATE TABLE `bank_account` (
  `id` int(11) NOT NULL,
  `account_number` varchar(50) NOT NULL,
  `currency` enum('USD','BIF') NOT NULL,
  `is_main` tinyint(1) NOT NULL DEFAULT 0,
  `balance` bigint(20) DEFAULT 0,
  `province_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_account`
--

-- --------------------------------------------------------

--
-- Table structure for table `bank_account_transaction`
--

CREATE TABLE `bank_account_transaction` (
  `id` int(11) NOT NULL,
  `bank_account_id` int(11) NOT NULL,
  `province_id` int(11) DEFAULT NULL,
  `transaction_type` enum('CASH_TRANSFER_RECEIVED','BANK_DEPOSIT','REVERSAL','ADJUSTMENT') NOT NULL,
  `direction` enum('CREDIT','DEBIT') NOT NULL,
  `amount` bigint(20) NOT NULL,
  `reference_type` enum('CASH_TRANSFER','CASH_DEPOSIT','MANUAL','OTHER') NOT NULL DEFAULT 'OTHER',
  `reference_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_account_transaction`
--

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit`
--

CREATE TABLE `bank_deposit` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_deposit`
--

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_backup`
--

CREATE TABLE `bank_deposit_backup` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_backup_2025`
--

CREATE TABLE `bank_deposit_backup_2025` (
  `id` int(11) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_new`
--

CREATE TABLE `bank_deposit_new` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `bank_deposit_new`
--

-- --------------------------------------------------------

--
-- Table structure for table `bank_deposit_v2`
--

CREATE TABLE `bank_deposit_v2` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `deposit_date` datetime NOT NULL DEFAULT current_timestamp(),
  `province_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cashier_account`
--

CREATE TABLE `cashier_account` (
  `id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `transaction_type` enum('SHIFT_START','SHIFT_END','INVOICE_PAYMENT','LOAN_REPAYMENT','REQUISITION_PAYMENT','EXPENSE','BANK_DEPOSIT','CASH_TRANSFER','ADJUSTMENT') NOT NULL,
  `direction` enum('CREDIT','DEBIT') NOT NULL,
  `amount` bigint(20) NOT NULL,
  `reference_type` enum('SHIFT','INVOICE','LOAN_PAYMENT','REQUISITION','EXPENSE','BANK_DEPOSIT','CASH_TRANSFER','MANUAL') NOT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_account`
--

-- --------------------------------------------------------

--
-- Table structure for table `cashier_balance`
--

CREATE TABLE `cashier_balance` (
  `id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `shift_start` datetime NOT NULL,
  `shift_end` datetime DEFAULT NULL,
  `beginning_balance` bigint(20) NOT NULL,
  `end_balance` bigint(20) DEFAULT NULL,
  `deposits` bigint(20) DEFAULT 0,
  `withdrawals` bigint(20) DEFAULT 0,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_balance`
--

-- --------------------------------------------------------

--
-- Table structure for table `cashier_shift_closure`
--

CREATE TABLE `cashier_shift_closure` (
  `id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `province_id` int(11) DEFAULT NULL,
  `expected_amount` bigint(20) NOT NULL,
  `counted_amount` bigint(20) NOT NULL,
  `difference_amount` int(11) NOT NULL,
  `deposited_to_bank` enum('yes','no') NOT NULL DEFAULT 'no',
  `transferred_to_accountant` enum('yes','no') NOT NULL DEFAULT 'no',
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_shift_closure`
--

-- --------------------------------------------------------

--
-- Table structure for table `cashier_shift_deposit`
--

CREATE TABLE `cashier_shift_deposit` (
  `id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `deposit_id` int(11) DEFAULT NULL,
  `bank_account_id` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `slip_number` varchar(255) DEFAULT NULL,
  `slip_file_path` varchar(255) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_shift_deposit`
--

-- --------------------------------------------------------

--
-- Table structure for table `cashier_shift_transfer`
--

CREATE TABLE `cashier_shift_transfer` (
  `id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `transfer_id` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cashier_shift_transfer`
--

-- --------------------------------------------------------

--
-- Table structure for table `cash_transfer`
--

CREATE TABLE `cash_transfer` (
  `id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `accountant_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `status` enum('pending','received','rejected') NOT NULL DEFAULT 'pending',
  `transfer_date` datetime DEFAULT current_timestamp(),
  `received_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cash_transfer`
--

-- --------------------------------------------------------

--
-- Table structure for table `cash_transfer_denomination`
--

CREATE TABLE `cash_transfer_denomination` (
  `id` int(11) NOT NULL,
  `transfer_id` int(11) NOT NULL,
  `denomination` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `company_info`
--

CREATE TABLE `company_info` (
  `id` int(11) NOT NULL,
  `company_name` varchar(100) NOT NULL,
  `address` text DEFAULT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(255) DEFAULT NULL,
  `phone1` varchar(20) DEFAULT NULL,
  `phone2` varchar(20) DEFAULT NULL,
  `website` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `logo_path` varchar(255) DEFAULT NULL,
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `company_info`
--

INSERT INTO `company_info` (`id`, `company_name`, `address`, `nif`, `rc`, `phone1`, `phone2`, `website`, `email`, `logo_path`, `updated_at`, `updated_by`) VALUES
(1, 'Masunzu Bar Hotel', '', '400000052', 'RC525665', '71256632', '71557481', 'htpps://www.masunzubarhotel.com', 'info@masunzubarhotel.com', 'assets/uploads/logos/6934ad349b959_logo.png', '2025-12-07 00:24:52', 1);
-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `id` int(11) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `tel` varchar(20) DEFAULT NULL,
  `driver_name` varchar(100) DEFAULT NULL,
  `driver_contacts` varchar(20) DEFAULT NULL,
  `plate_numbers` varchar(50) DEFAULT NULL,
  `additional_contacts` text DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `user_type` enum('moral','physical') NOT NULL DEFAULT 'physical',
  `balance` bigint(20) DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  `can_pay_by_loan` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Indicates if the customer can pay via loan (0 = No, 1 = Yes)',
  `loan_limit_bif` bigint(20) NOT NULL DEFAULT 0,
  `loan_balance_bif` bigint(20) NOT NULL DEFAULT 0,
  `loan_terms_days` int(11) DEFAULT NULL,
  `loan_status` enum('inactive','active','suspended') NOT NULL DEFAULT 'inactive',
  `loan_last_review_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customer`
--

-- --------------------------------------------------------

--
-- Table structure for table `customer_balance`
--

CREATE TABLE `customer_balance` (
  `id` int(11) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `action` enum('add','subtract') NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_loan_ledger`
--

CREATE TABLE `customer_loan_ledger` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `entry_type` enum('loan_sale','loan_repayment','adjustment') NOT NULL,
  `entry_origin` varchar(32) NOT NULL DEFAULT 'system',
  `direction` enum('debit','credit') NOT NULL,
  `amount_bif` bigint(20) NOT NULL,
  `reference_table` varchar(50) DEFAULT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customer_loan_ledger`
--

-- --------------------------------------------------------

--
-- Table structure for table `department`
--

CREATE TABLE `department` (
  `id` int(11) NOT NULL,
  `code` varchar(50) NOT NULL,
  `label` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `expense`
--

CREATE TABLE `expense` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) NOT NULL,
  `cashier_id` int(11) NOT NULL,
  `receiver_user_id` int(11) DEFAULT NULL,
  `receiver_external_name` varchar(255) DEFAULT NULL,
  `receiver_external_phone` varchar(20) DEFAULT NULL,
  `amount` bigint(20) NOT NULL,
  `receipt_number` varchar(50) NOT NULL,
  `recipient_signature` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `accountant_id` int(11) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `payment_status` enum('pending','processed','completed') NOT NULL DEFAULT 'pending',
  `payment_method` enum('cash','bank_transfer','mobile') DEFAULT 'cash'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `expense`
--

-- --------------------------------------------------------

--
-- Table structure for table `field_observation`
--

CREATE TABLE `field_observation` (
  `id` int(11) NOT NULL,
  `author_id` int(11) NOT NULL,
  `region_id` int(11) DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL,
  `subject` varchar(150) DEFAULT NULL,
  `details` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `field_observation`
--

-- --------------------------------------------------------

--
-- Table structure for table `invoice`
--

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) DEFAULT NULL,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'pending',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `created_by` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Pending',
  `paid_amount` bigint(20) NOT NULL,
  `province_stock_id` int(11) DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `assigned_cashier_id` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `approved_at` datetime DEFAULT NULL,
  `approval_comments` text DEFAULT NULL,
  `reject_comments` text DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `expiration_status` enum('pending','expired','finalized') DEFAULT 'pending'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_items`
--

CREATE TABLE `invoice_items` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` bigint(20) NOT NULL,
  `price_source` varchar(20) DEFAULT 'system',
  `system_unit_price` bigint(20) DEFAULT NULL,
  `custom_unit_price` bigint(20) DEFAULT NULL,
  `custom_price_basis` varchar(50) DEFAULT NULL,
  `custom_price_input` bigint(20) DEFAULT NULL,
  `custom_price_note` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `invoice_items`
--

-- --------------------------------------------------------

--
-- Table structure for table `invoice_log`
--

CREATE TABLE `invoice_log` (
  `id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `created_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_price_adjustment_history`
--

CREATE TABLE `invoice_price_adjustment_history` (
  `id` int(11) NOT NULL,
  `unpaid_invoice_id` int(11) NOT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `product_id` int(11) NOT NULL,
  `price_source` varchar(20) DEFAULT 'custom',
  `original_unit_price` bigint(20) NOT NULL DEFAULT 0,
  `new_unit_price` bigint(20) NOT NULL DEFAULT 0,
  `custom_price_basis` varchar(50) DEFAULT NULL,
  `custom_price_input` bigint(20) DEFAULT NULL,
  `quantity_units` int(11) DEFAULT NULL,
  `changed_by` int(11) NOT NULL,
  `change_note` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `loan_payment`
--

CREATE TABLE `loan_payment` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `order_id` int(11) DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `ledger_entry_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `payment_amount` bigint(20) NOT NULL,
  `payment_method` enum('cash','bank_transfer','mobile','bank_deposit') DEFAULT NULL,
  `payment_date` datetime DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `loan_payment`
--

-- --------------------------------------------------------

--
-- Table structure for table `log`
--

CREATE TABLE `log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `log`
--

-- --------------------------------------------------------

--
-- Table structure for table `main_stock`
--

CREATE TABLE `main_stock` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `main_stock`
--

-- --------------------------------------------------------

--
-- Table structure for table `operation_manager_stock`
--

CREATE TABLE `operation_manager_stock` (
  `id` int(11) NOT NULL,
  `operation_manager_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order`
--

CREATE TABLE `order` (
  `id` int(11) NOT NULL,
  `agent_id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `order_type` enum('wholesale','retail') NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `approved_by_stock_manager` int(11) DEFAULT NULL,
  `approved_by_operation_manager` int(11) DEFAULT NULL,
  `is_credit` tinyint(1) NOT NULL DEFAULT 0,
  `credit_approved_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(100) DEFAULT NULL,
  `table_number` varchar(50) DEFAULT NULL,
  `receipt_number` varchar(50) DEFAULT NULL,
  `payment_method` enum('cash','bank_transfer','mobile') DEFAULT NULL,
  `payment_details` text DEFAULT NULL,
  `paid_amount` bigint(20) DEFAULT NULL,
  `subtotal_amount` bigint(20) DEFAULT NULL,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `total_with_tax` bigint(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `phone_number` varchar(20) DEFAULT NULL,
  `sale_type` enum('retail','wholesale') NOT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `paid_status` enum('Paid','Unpaid') NOT NULL DEFAULT 'Unpaid',
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Pending',
  `province_stock_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paid_invoices`
--

CREATE TABLE `paid_invoices` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `is_loan_sale` tinyint(1) NOT NULL DEFAULT 0,
  `loan_amount_bif` bigint(20) NOT NULL DEFAULT 0,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'paid',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Served',
  `paid_amount` bigint(20) NOT NULL,
  `subtotal_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'approved',
  `approved_at` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `paid_at` datetime NOT NULL DEFAULT current_timestamp(),
  `payment_method` enum('cash','bank_transfer','mobile') DEFAULT NULL,
  `payment_details` text DEFAULT NULL,
  `served_by` int(11) DEFAULT NULL,
  `sale_type` enum('retail','wholesale') NOT NULL DEFAULT 'retail',
  `served_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `expiration_status` enum('pending','expired','finalized') DEFAULT 'pending'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `paid_invoices`
--

-- --------------------------------------------------------

--
-- Table structure for table `paid_invoices_backup_20251010`
--

CREATE TABLE `paid_invoices_backup_20251010` (
  `id` int(11) NOT NULL DEFAULT 0,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'paid',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `serve_status` enum('Pending','Served') NOT NULL DEFAULT 'Served',
  `paid_amount` bigint(20) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'approved',
  `approved_at` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `paid_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paid_invoice_items`
--

CREATE TABLE `paid_invoice_items` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` bigint(20) NOT NULL,
  `price_source` varchar(20) DEFAULT 'system',
  `system_unit_price` bigint(20) DEFAULT NULL,
  `custom_unit_price` bigint(20) DEFAULT NULL,
  `custom_price_basis` varchar(50) DEFAULT NULL,
  `custom_price_input` bigint(20) DEFAULT NULL,
  `custom_price_note` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `paid_invoice_items`
--

-- --------------------------------------------------------

--
-- Table structure for table `product`
--

CREATE TABLE `product` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `volume_cl` int(11) NOT NULL,
  `crate_quantity` int(11) NOT NULL,
  `low_stock_alert_crates` int(11) DEFAULT NULL,
  `low_stock_alert_units` int(11) DEFAULT NULL,
  `expiration_date` date DEFAULT NULL,
  `price_per_crate` int(11) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `product`
--

-- --------------------------------------------------------

--
-- Table structure for table `product_price_history`
--

CREATE TABLE `product_price_history` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `old_price` int(11) NOT NULL,
  `new_price` int(11) NOT NULL,
  `changed_by` int(11) NOT NULL,
  `changed_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `product_price_history`
--

-- --------------------------------------------------------

--
-- Table structure for table `province`
--

CREATE TABLE `province` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `region_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province`
--

-- --------------------------------------------------------

--
-- Table structure for table `province_cash_account`
--

CREATE TABLE `province_cash_account` (
  `province_id` int(11) NOT NULL,
  `balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province_cash_account`
--

-- --------------------------------------------------------

--
-- Table structure for table `province_cash_transaction`
--

CREATE TABLE `province_cash_transaction` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `txn_type` enum('CASH_RECEIVED','REQUISITION_PAYMENT','BANK_DEPOSIT','ADJUSTMENT') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `direction` enum('CREDIT','DEBIT') NOT NULL,
  `reference_type` enum('INVOICE','REQUISITION','BANK_DEPOSIT','OTHER') DEFAULT 'OTHER',
  `reference_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `running_balance` decimal(15,2) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province_cash_transaction`
--

-- --------------------------------------------------------

--
-- Table structure for table `province_stock`
--

CREATE TABLE `province_stock` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `province_stock`
--

-- --------------------------------------------------------

--
-- Table structure for table `receipts`
--

CREATE TABLE `receipts` (
  `receipt_id` varchar(36) NOT NULL,
  `transaction_type` enum('direct_sale','invoice') NOT NULL,
  `transaction_id` int(11) NOT NULL,
  `receipt_number` varchar(50) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `total_amount` bigint(20) NOT NULL,
  `subtotal_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `created_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `pdf_content` longblob DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `receipts`
--

-- --------------------------------------------------------

--
-- Table structure for table `region`
--

CREATE TABLE `region` (
  `id` int(11) NOT NULL,
  `code` varchar(10) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `region`
--

INSERT INTO `region` (`id`, `code`, `name`, `created_at`) VALUES
(1, 'BJM', 'Bujumbura', '2025-11-20 00:00:00'),
(2, 'BRG', 'Burunga', '2025-11-20 00:00:00'),
(3, 'BTN', 'Butanyerera', '2025-11-20 00:00:00'),
(4, 'GTG', 'Gitega', '2025-11-20 00:00:00'),
(5, 'BHM', 'Buhumuza', '2025-11-20 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `region_stock`
--

CREATE TABLE `region_stock` (
  `id` int(11) NOT NULL,
  `region_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved_quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `requisition`
--

CREATE TABLE `requisition` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `total_amount` int(10) NOT NULL,
  `original_total_amount` int(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `approved_by` int(11) DEFAULT NULL,
  `assigned_cashier_id` int(11) DEFAULT NULL,
  `recipient_id` int(11) DEFAULT NULL,
  `recipient_type` enum('internal','external') NOT NULL DEFAULT 'internal',
  `recipient_external_name` varchar(255) DEFAULT NULL,
  `recipient_external_phone` varchar(20) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `last_amount_modified_at` datetime DEFAULT NULL,
  `last_amount_modified_by` int(11) DEFAULT NULL,
  `province_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `requisition`
--

-- --------------------------------------------------------

--
-- Table structure for table `requisition_amount_history`
--

CREATE TABLE `requisition_amount_history` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) NOT NULL,
  `old_amount` int(11) NOT NULL,
  `new_amount` int(11) NOT NULL,
  `changed_by` int(11) NOT NULL,
  `changed_at` datetime NOT NULL DEFAULT current_timestamp(),
  `reason` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `requisition_amount_history`
--

-- --------------------------------------------------------

--
-- Table structure for table `requisition_item`
--

CREATE TABLE `requisition_item` (
  `id` int(11) NOT NULL,
  `requisition_id` int(11) NOT NULL,
  `category` enum('communication','transport','frais_de_mission','office_utilities','maintenance','autre','loyer','ration') NOT NULL,
  `description` text NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `requisition_item`
--

-- --------------------------------------------------------

--
-- Table structure for table `retail_stock`
--

CREATE TABLE `retail_stock` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `role`
--

CREATE TABLE `role` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `role`
--

INSERT INTO `role` (`id`, `name`, `description`) VALUES
(1, 'DG', 'Directeur Gérant, valide les budgets et supervise la vision'),
(2, 'DGA', 'Directeur Général Adjoint, supervise opérations et finances'),
(3, 'Admin', 'Administrateur du système'),
(4, 'Accountant', 'Comptable'),
(5, 'Stock Manager', 'Gestionnaire de dépôts (Technique)'),
(6, 'Caissier_Comptable', 'Responsable caisse et comptabilité terrain'),
(7, 'Operation Manager', 'Responsable Opérations Régionales'),
(8, 'Chef Marketing', 'Pilote l\'équipe commerciale'),
(9, 'Agent Marketing', 'Développement commercial terrain'),
(10, 'Conseil d\'Administration', 'Membres du Conseil d\'Administration (droits étendus sans approbation)');

-- --------------------------------------------------------

--
-- Table structure for table `stock_adjustment`
--

CREATE TABLE `stock_adjustment` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `from_stock_type` enum('province','wholesale','retail') NOT NULL,
  `to_stock_type` enum('province','wholesale','retail') DEFAULT NULL,
  `quantity_moved` int(11) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `adjusted_at` datetime NOT NULL DEFAULT current_timestamp(),
  `stock_manager_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stock_split`
--

CREATE TABLE `stock_split` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `quantity_to_wholesale` int(11) NOT NULL,
  `quantity_to_retail` int(11) NOT NULL,
  `split_at` datetime NOT NULL,
  `stock_manager_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stock_transfer`
--

CREATE TABLE `stock_transfer` (
  `id` int(11) NOT NULL,
  `operation_manager_id` int(11) NOT NULL,
  `operation_receiver_id` int(11) DEFAULT NULL,
  `stock_manager_id` int(11) DEFAULT NULL,
  `initiator_id` int(11) DEFAULT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `province_id` int(11) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `status` enum('pending','confirmed','rejected') NOT NULL DEFAULT 'pending',
  `sent_at` datetime NOT NULL DEFAULT current_timestamp(),
  `received_at` datetime DEFAULT NULL,
  `estimated_arrival` datetime NOT NULL DEFAULT '2025-09-21 00:00:00',
  `driver_name` varchar(100) NOT NULL DEFAULT '',
  `driver_mobile` varchar(20) NOT NULL DEFAULT '',
  `plate_number` varchar(20) NOT NULL DEFAULT '',
  `shipment_id` int(11) NOT NULL DEFAULT 0,
  `total_amount` int(11) NOT NULL DEFAULT 0,
  `total_products` int(11) NOT NULL DEFAULT 0,
  `main_stock_id` int(11) DEFAULT NULL,
  `province_stock_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `stock_transfer`
--

-- --------------------------------------------------------

--
-- Table structure for table `supplier`
--

CREATE TABLE `supplier` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `supplier_product`
--

CREATE TABLE `supplier_product` (
  `supplier_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `unpaid_invoices`
--

CREATE TABLE `unpaid_invoices` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `is_loan_sale` tinyint(1) NOT NULL DEFAULT 0,
  `has_custom_prices` tinyint(1) NOT NULL DEFAULT 0,
  `custom_price_summary` text DEFAULT NULL,
  `loan_due_date` date DEFAULT NULL,
  `loan_outstanding_bif` bigint(20) NOT NULL DEFAULT 0,
  `loan_status` enum('pending','overdue','settled') DEFAULT NULL,
  `stock_manager_id` int(11) NOT NULL,
  `status` enum('pending','paid','unpaid') NOT NULL DEFAULT 'pending',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `customer_name` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `province_id` int(11) NOT NULL,
  `nif` varchar(50) DEFAULT NULL,
  `rc` varchar(50) DEFAULT NULL,
  `invoice_number` varchar(20) NOT NULL,
  `paid_amount` bigint(20) NOT NULL DEFAULT 0,
  `subtotal_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_amount` bigint(20) NOT NULL DEFAULT 0,
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 18.00,
  `tax_mode` enum('HTVA','TVAC') NOT NULL DEFAULT 'HTVA',
  `approved_by` int(11) DEFAULT NULL,
  `approval_status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `approved_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `unpaid_invoices`
--

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` int(11) NOT NULL,
  `province_id` int(11) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `full_name` varchar(100) NOT NULL,
  `position` varchar(100) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `mobile1` varchar(20) DEFAULT NULL,
  `mobile2` varchar(20) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user`
--

INSERT INTO `user` (`id`, `username`, `password`, `role_id`, `province_id`, `region_id`, `full_name`, `position`, `address`, `email`, `mobile1`, `mobile2`, `created_at`, `updated_at`, `is_active`) VALUES
(1, 'admin', '$2y$10$QCGAUgx/pV3F4gKAGRMXoevEEO6Sb1j6P7iFoejzaje7K08aYcVMC', 3, NULL, NULL, 'Administrateur Principal', 'Administrateur Système', NULL, 'admin@masunzu.com', NULL, NULL, '2025-11-13 18:59:07', '2025-11-28 15:55:23', 1);
-- --------------------------------------------------------

--
-- Table structure for table `user_change_history`
--

CREATE TABLE `user_change_history` (
  `id` int(11) NOT NULL,
  `target_user_id` int(11) NOT NULL,
  `action` enum('create','edit') NOT NULL,
  `changed_by` int(11) NOT NULL,
  `change_details` longtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_change_history`
--

-- --------------------------------------------------------

--
-- Table structure for table `user_department`
--

CREATE TABLE `user_department` (
  `user_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `assigned_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_notification`
--

CREATE TABLE `user_notification` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` varchar(255) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_notification`
--

-- --------------------------------------------------------

--
-- Table structure for table `user_session`
--

CREATE TABLE `user_session` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `session_id` varchar(100) NOT NULL,
  `login_time` datetime DEFAULT current_timestamp(),
  `last_activity` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `logout_time` datetime DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_session`
--

-- --------------------------------------------------------

--
-- Table structure for table `wholesale_stock`
--

CREATE TABLE `wholesale_stock` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `unit_type` enum('crates') NOT NULL DEFAULT 'crates',
  `last_updated` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `accountant_balance`
--
ALTER TABLE `accountant_balance`
  ADD PRIMARY KEY (`id`),
  ADD KEY `accountant_id` (`accountant_id`);

--
-- Indexes for table `audit_log`
--
ALTER TABLE `audit_log`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `bank_account`
--
ALTER TABLE `bank_account`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `account_number` (`account_number`),
  ADD KEY `province_id` (`province_id`);

--
-- Indexes for table `bank_account_transaction`
--
ALTER TABLE `bank_account_transaction`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_account_created_at` (`bank_account_id`,`created_at`),
  ADD KEY `idx_reference` (`reference_type`,`reference_id`),
  ADD KEY `fk_bat_province` (`province_id`),
  ADD KEY `fk_bat_user` (`created_by`);

--
-- Indexes for table `bank_deposit`
--
ALTER TABLE `bank_deposit`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `bank_deposit_backup`
--
ALTER TABLE `bank_deposit_backup`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `bank_deposit_new`
--
ALTER TABLE `bank_deposit_new`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `bank_deposit_v2`
--
ALTER TABLE `bank_deposit_v2`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_province` (`province_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `idx_deposit_date` (`deposit_date`);

--
-- Indexes for table `cashier_account`
--
ALTER TABLE `cashier_account`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_cashier_created` (`cashier_id`,`created_at`),
  ADD KEY `idx_shift` (`shift_id`),
  ADD KEY `idx_reference` (`reference_type`,`reference_id`),
  ADD KEY `idx_transaction_type` (`transaction_type`),
  ADD KEY `fk_ca_creator` (`created_by`);

--
-- Indexes for table `cashier_balance`
--
ALTER TABLE `cashier_balance`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cashier_id` (`cashier_id`);

--
-- Indexes for table `cashier_shift_closure`
--
ALTER TABLE `cashier_shift_closure`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_closure_shift` (`shift_id`),
  ADD KEY `fk_closure_cashier` (`cashier_id`);

--
-- Indexes for table `cashier_shift_deposit`
--
ALTER TABLE `cashier_shift_deposit`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_shift` (`shift_id`),
  ADD KEY `idx_bank_account` (`bank_account_id`),
  ADD KEY `fk_shift_deposit_deposit` (`deposit_id`),
  ADD KEY `fk_shift_deposit_user` (`created_by`);

--
-- Indexes for table `cashier_shift_transfer`
--
ALTER TABLE `cashier_shift_transfer`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_shift` (`shift_id`),
  ADD KEY `idx_transfer` (`transfer_id`),
  ADD KEY `fk_shift_transfer_user` (`created_by`);

--
-- Indexes for table `cash_transfer`
--
ALTER TABLE `cash_transfer`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cashier_id` (`cashier_id`),
  ADD KEY `accountant_id` (`accountant_id`);

--
-- Indexes for table `cash_transfer_denomination`
--
ALTER TABLE `cash_transfer_denomination`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_transfer_denom` (`transfer_id`,`denomination`);

--
-- Indexes for table `company_info`
--
ALTER TABLE `company_info`
  ADD PRIMARY KEY (`id`),
  ADD KEY `updated_by` (`updated_by`);

--
-- Indexes for table `customer`
--
ALTER TABLE `customer`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `customer_balance`
--
ALTER TABLE `customer_balance`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `customer_loan_ledger`
--
ALTER TABLE `customer_loan_ledger`
  ADD PRIMARY KEY (`id`),
  ADD KEY `customer_id_idx` (`customer_id`),
  ADD KEY `created_by_idx` (`created_by`);

--
-- Indexes for table `department`
--
ALTER TABLE `department`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `expense`
--
ALTER TABLE `expense`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `receipt_number` (`receipt_number`),
  ADD KEY `requisition_id` (`requisition_id`),
  ADD KEY `cashier_id` (`cashier_id`),
  ADD KEY `accountant_id` (`accountant_id`),
  ADD KEY `approved_by` (`approved_by`),
  ADD KEY `expense_receiver_fk` (`receiver_user_id`);

--
-- Indexes for table `field_observation`
--
ALTER TABLE `field_observation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `author_id` (`author_id`),
  ADD KEY `region_id` (`region_id`),
  ADD KEY `province_id` (`province_id`);

--
-- Indexes for table `invoice`
--
ALTER TABLE `invoice`
  ADD PRIMARY KEY (`id`),
  ADD KEY `requisition_id` (`requisition_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `province_stock_id` (`province_stock_id`),
  ADD KEY `approved_by` (`approved_by`),
  ADD KEY `idx_invoice_assigned_cashier` (`assigned_cashier_id`);

--
-- Indexes for table `invoice_items`
--
ALTER TABLE `invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `invoice_items_ibfk_1` (`invoice_id`);

--
-- Indexes for table `invoice_log`
--
ALTER TABLE `invoice_log`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `invoice_price_adjustment_history`
--
ALTER TABLE `invoice_price_adjustment_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_unpaid_invoice` (`unpaid_invoice_id`),
  ADD KEY `idx_product` (`product_id`),
  ADD KEY `idx_changed_by` (`changed_by`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `loan_payment`
--
ALTER TABLE `loan_payment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `loan_payment_customer_idx` (`customer_id`),
  ADD KEY `loan_payment_order_idx` (`order_id`),
  ADD KEY `loan_payment_invoice_idx` (`invoice_id`),
  ADD KEY `loan_payment_created_idx` (`created_by`),
  ADD KEY `loan_payment_province_idx` (`province_id`),
  ADD KEY `loan_payment_ledger_fk` (`ledger_entry_id`);

--
-- Indexes for table `log`
--
ALTER TABLE `log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `main_stock`
--
ALTER TABLE `main_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_main_stock` (`product_id`);

--
-- Indexes for table `operation_manager_stock`
--
ALTER TABLE `operation_manager_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_manager_product` (`operation_manager_id`,`product_id`),
  ADD KEY `idx_operation_stock_product` (`product_id`),
  ADD KEY `idx_operation_stock_manager` (`operation_manager_id`);

--
-- Indexes for table `order`
--
ALTER TABLE `order`
  ADD PRIMARY KEY (`id`),
  ADD KEY `agent_id` (`agent_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `approved_by_stock_manager` (`approved_by_stock_manager`),
  ADD KEY `approved_by_operation_manager` (`approved_by_operation_manager`),
  ADD KEY `credit_approved_by` (`credit_approved_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `province_stock_id` (`province_stock_id`),
  ADD KEY `customer_id` (`customer_id`);

--
-- Indexes for table `paid_invoices`
--
ALTER TABLE `paid_invoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `paid_invoices_served_by_fk` (`served_by`),
  ADD KEY `paid_invoices_customer_idx` (`customer_id`);

--
-- Indexes for table `paid_invoice_items`
--
ALTER TABLE `paid_invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoice_id` (`invoice_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `product`
--
ALTER TABLE `product`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_name` (`name`);

--
-- Indexes for table `product_price_history`
--
ALTER TABLE `product_price_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_product` (`product_id`),
  ADD KEY `idx_changed_at` (`changed_at`),
  ADD KEY `changed_by` (`changed_by`);

--
-- Indexes for table `province`
--
ALTER TABLE `province`
  ADD PRIMARY KEY (`id`),
  ADD KEY `region_id` (`region_id`);

--
-- Indexes for table `province_cash_account`
--
ALTER TABLE `province_cash_account`
  ADD PRIMARY KEY (`province_id`);

--
-- Indexes for table `province_cash_transaction`
--
ALTER TABLE `province_cash_transaction`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_pct_prov_date` (`province_id`,`created_at`),
  ADD KEY `idx_pct_ref` (`reference_type`,`reference_id`),
  ADD KEY `fk_pct_user` (`created_by`);

--
-- Indexes for table `province_stock`
--
ALTER TABLE `province_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_province_stock` (`province_id`,`product_id`),
  ADD KEY `province_stock_ibfk_2` (`product_id`);

--
-- Indexes for table `receipts`
--
ALTER TABLE `receipts`
  ADD PRIMARY KEY (`receipt_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `region`
--
ALTER TABLE `region`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `region_stock`
--
ALTER TABLE `region_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_region_product` (`region_id`,`product_id`),
  ADD KEY `idx_region_stock_product` (`product_id`);

--
-- Indexes for table `requisition`
--
ALTER TABLE `requisition`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `recipient_id` (`recipient_id`),
  ADD KEY `idx_requisition_assigned_cashier` (`assigned_cashier_id`);

--
-- Indexes for table `requisition_amount_history`
--
ALTER TABLE `requisition_amount_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `req_amount_history_requisition_idx` (`requisition_id`),
  ADD KEY `req_amount_history_user_idx` (`changed_by`);

--
-- Indexes for table `requisition_item`
--
ALTER TABLE `requisition_item`
  ADD PRIMARY KEY (`id`),
  ADD KEY `requisition_id` (`requisition_id`);

--
-- Indexes for table `retail_stock`
--
ALTER TABLE `retail_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_retail_stock` (`province_id`,`product_id`),
  ADD KEY `retail_stock_ibfk_2` (`product_id`);

--
-- Indexes for table `role`
--
ALTER TABLE `role`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `stock_adjustment`
--
ALTER TABLE `stock_adjustment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`);

--
-- Indexes for table `stock_split`
--
ALTER TABLE `stock_split`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`);

--
-- Indexes for table `stock_transfer`
--
ALTER TABLE `stock_transfer`
  ADD PRIMARY KEY (`id`),
  ADD KEY `operation_manager_id` (`operation_manager_id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `region_id` (`region_id`),
  ADD KEY `main_stock_id` (`main_stock_id`),
  ADD KEY `province_stock_id` (`province_stock_id`),
  ADD KEY `operation_receiver_id` (`operation_receiver_id`),
  ADD KEY `initiator_id` (`initiator_id`);

--
-- Indexes for table `supplier`
--
ALTER TABLE `supplier`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `supplier_product`
--
ALTER TABLE `supplier_product`
  ADD PRIMARY KEY (`supplier_id`,`product_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `unpaid_invoices`
--
ALTER TABLE `unpaid_invoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `stock_manager_id` (`stock_manager_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `unpaid_invoices_customer_idx` (`customer_id`);

--
-- Indexes for table `user`
--
ALTER TABLE `user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `role_id` (`role_id`),
  ADD KEY `province_id` (`province_id`),
  ADD KEY `region_id` (`region_id`);

--
-- Indexes for table `user_change_history`
--
ALTER TABLE `user_change_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_target_user` (`target_user_id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_changed_by` (`changed_by`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `user_department`
--
ALTER TABLE `user_department`
  ADD PRIMARY KEY (`user_id`,`department_id`),
  ADD KEY `department_id` (`department_id`);

--
-- Indexes for table `user_notification`
--
ALTER TABLE `user_notification`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_read` (`user_id`,`is_read`);

--
-- Indexes for table `user_session`
--
ALTER TABLE `user_session`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_session_id` (`session_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `login_time` (`login_time`);

--
-- Indexes for table `wholesale_stock`
--
ALTER TABLE `wholesale_stock`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_wholesale_stock` (`province_id`,`product_id`),
  ADD KEY `wholesale_stock_ibfk_2` (`product_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `bank_account`
--
ALTER TABLE `bank_account`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `bank_account_transaction`
--
ALTER TABLE `bank_account_transaction`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `bank_deposit`
--
ALTER TABLE `bank_deposit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `bank_deposit_backup`
--
ALTER TABLE `bank_deposit_backup`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bank_deposit_new`
--
ALTER TABLE `bank_deposit_new`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `bank_deposit_v2`
--
ALTER TABLE `bank_deposit_v2`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `cashier_account`
--
ALTER TABLE `cashier_account`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `cashier_balance`
--
ALTER TABLE `cashier_balance`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `cashier_shift_closure`
--
ALTER TABLE `cashier_shift_closure`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `cashier_shift_deposit`
--
ALTER TABLE `cashier_shift_deposit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `cashier_shift_transfer`
--
ALTER TABLE `cashier_shift_transfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `cash_transfer`
--
ALTER TABLE `cash_transfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `company_info`
--
ALTER TABLE `company_info`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `customer`
--
ALTER TABLE `customer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `customer_loan_ledger`
--
ALTER TABLE `customer_loan_ledger`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `department`
--
ALTER TABLE `department`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `expense`
--
ALTER TABLE `expense`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `field_observation`
--
ALTER TABLE `field_observation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `invoice_items`
--
ALTER TABLE `invoice_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `loan_payment`
--
ALTER TABLE `loan_payment`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `log`
--
ALTER TABLE `log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `main_stock`
--
ALTER TABLE `main_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `operation_manager_stock`
--
ALTER TABLE `operation_manager_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paid_invoices`
--
ALTER TABLE `paid_invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `paid_invoice_items`
--
ALTER TABLE `paid_invoice_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `product`
--
ALTER TABLE `product`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `product_price_history`
--
ALTER TABLE `product_price_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `province`
--
ALTER TABLE `province`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `province_cash_transaction`
--
ALTER TABLE `province_cash_transaction`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `province_stock`
--
ALTER TABLE `province_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `region`
--
ALTER TABLE `region`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `region_stock`
--
ALTER TABLE `region_stock`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `requisition`
--
ALTER TABLE `requisition`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `requisition_amount_history`
--
ALTER TABLE `requisition_amount_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `requisition_item`
--
ALTER TABLE `requisition_item`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `stock_transfer`
--
ALTER TABLE `stock_transfer`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `unpaid_invoices`
--
ALTER TABLE `unpaid_invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `user`
--
ALTER TABLE `user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `user_change_history`
--
ALTER TABLE `user_change_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `user_notification`
--
ALTER TABLE `user_notification`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `user_session`
--
ALTER TABLE `user_session`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `accountant_balance`
--
ALTER TABLE `accountant_balance`
  ADD CONSTRAINT `accountant_balance_ibfk_1` FOREIGN KEY (`accountant_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `bank_account`
--
ALTER TABLE `bank_account`
  ADD CONSTRAINT `bank_account_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`);

--
-- Constraints for table `bank_account_transaction`
--
ALTER TABLE `bank_account_transaction`
  ADD CONSTRAINT `fk_bat_account` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_account` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_bat_province` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_bat_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `cashier_account`
--
ALTER TABLE `cashier_account`
  ADD CONSTRAINT `fk_ca_cashier` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_ca_creator` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_ca_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `cashier_balance`
--
ALTER TABLE `cashier_balance`
  ADD CONSTRAINT `cashier_balance_ibfk_1` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `cashier_shift_closure`
--
ALTER TABLE `cashier_shift_closure`
  ADD CONSTRAINT `fk_closure_cashier` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_closure_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cashier_shift_deposit`
--
ALTER TABLE `cashier_shift_deposit`
  ADD CONSTRAINT `fk_shift_deposit_bank` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_account` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_shift_deposit_deposit` FOREIGN KEY (`deposit_id`) REFERENCES `bank_deposit_new` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_deposit_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_deposit_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cashier_shift_transfer`
--
ALTER TABLE `cashier_shift_transfer`
  ADD CONSTRAINT `fk_shift_transfer_shift` FOREIGN KEY (`shift_id`) REFERENCES `cashier_balance` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_transfer_transfer` FOREIGN KEY (`transfer_id`) REFERENCES `cash_transfer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_shift_transfer_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cash_transfer`
--
ALTER TABLE `cash_transfer`
  ADD CONSTRAINT `cash_transfer_ibfk_1` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `cash_transfer_ibfk_2` FOREIGN KEY (`accountant_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `cash_transfer_denomination`
--
ALTER TABLE `cash_transfer_denomination`
  ADD CONSTRAINT `fk_denom_transfer` FOREIGN KEY (`transfer_id`) REFERENCES `cash_transfer` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `company_info`
--
ALTER TABLE `company_info`
  ADD CONSTRAINT `company_info_ibfk_2` FOREIGN KEY (`updated_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `customer`
--
ALTER TABLE `customer`
  ADD CONSTRAINT `customer_ibfk_created_by` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `customer_balance`
--
ALTER TABLE `customer_balance`
  ADD CONSTRAINT `customer_balance_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `customer_loan_ledger`
--
ALTER TABLE `customer_loan_ledger`
  ADD CONSTRAINT `customer_loan_ledger_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `customer_loan_ledger_user_fk` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `expense`
--
ALTER TABLE `expense`
  ADD CONSTRAINT `expense_ibfk_1` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`),
  ADD CONSTRAINT `expense_ibfk_2` FOREIGN KEY (`cashier_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `expense_ibfk_3` FOREIGN KEY (`accountant_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `expense_ibfk_4` FOREIGN KEY (`approved_by`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `expense_receiver_fk` FOREIGN KEY (`receiver_user_id`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `field_observation`
--
ALTER TABLE `field_observation`
  ADD CONSTRAINT `field_observation_author_fk` FOREIGN KEY (`author_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `field_observation_depot_fk` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `field_observation_region_fk` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `invoice`
--
ALTER TABLE `invoice`
  ADD CONSTRAINT `fk_invoice_assigned_cashier` FOREIGN KEY (`assigned_cashier_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `invoice_ibfk_2` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `invoice_ibfk_3` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `invoice_ibfk_4` FOREIGN KEY (`province_stock_id`) REFERENCES `province_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `invoice_ibfk_6` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `invoice_ibfk_7` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `invoice_ibfk_8` FOREIGN KEY (`approved_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `invoice_items`
--
ALTER TABLE `invoice_items`
  ADD CONSTRAINT `invoice_items_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `unpaid_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `invoice_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `loan_payment`
--
ALTER TABLE `loan_payment`
  ADD CONSTRAINT `loan_payment_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`),
  ADD CONSTRAINT `loan_payment_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`),
  ADD CONSTRAINT `loan_payment_ibfk_2` FOREIGN KEY (`order_id`) REFERENCES `order` (`id`),
  ADD CONSTRAINT `loan_payment_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `loan_payment_invoice_fk` FOREIGN KEY (`invoice_id`) REFERENCES `paid_invoices` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `loan_payment_ledger_fk` FOREIGN KEY (`ledger_entry_id`) REFERENCES `customer_loan_ledger` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `loan_payment_order_fk` FOREIGN KEY (`order_id`) REFERENCES `order` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `loan_payment_user_fk` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `log`
--
ALTER TABLE `log`
  ADD CONSTRAINT `log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `main_stock`
--
ALTER TABLE `main_stock`
  ADD CONSTRAINT `main_stock_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `operation_manager_stock`
--
ALTER TABLE `operation_manager_stock`
  ADD CONSTRAINT `operation_manager_stock_ibfk_1` FOREIGN KEY (`operation_manager_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `operation_manager_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `order`
--
ALTER TABLE `order`
  ADD CONSTRAINT `order_ibfk_1` FOREIGN KEY (`agent_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `order_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `order_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `order_ibfk_4` FOREIGN KEY (`approved_by_stock_manager`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_5` FOREIGN KEY (`approved_by_operation_manager`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_6` FOREIGN KEY (`credit_approved_by`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_7` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `order_ibfk_8` FOREIGN KEY (`province_stock_id`) REFERENCES `province_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `order_ibfk_9` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `paid_invoices`
--
ALTER TABLE `paid_invoices`
  ADD CONSTRAINT `paid_invoices_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `paid_invoices_ibfk_1` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `paid_invoices_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `paid_invoices_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `paid_invoices_served_by_fk` FOREIGN KEY (`served_by`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `paid_invoice_items`
--
ALTER TABLE `paid_invoice_items`
  ADD CONSTRAINT `paid_invoice_items_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `paid_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `paid_invoice_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `product_price_history`
--
ALTER TABLE `product_price_history`
  ADD CONSTRAINT `product_price_history_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `product_price_history_ibfk_2` FOREIGN KEY (`changed_by`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `province`
--
ALTER TABLE `province`
  ADD CONSTRAINT `fk_province_region` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `province_cash_account`
--
ALTER TABLE `province_cash_account`
  ADD CONSTRAINT `fk_pca_province` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`);

--
-- Constraints for table `province_cash_transaction`
--
ALTER TABLE `province_cash_transaction`
  ADD CONSTRAINT `fk_pct_province` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `fk_pct_user` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `province_stock`
--
ALTER TABLE `province_stock`
  ADD CONSTRAINT `province_stock_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `province_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `receipts`
--
ALTER TABLE `receipts`
  ADD CONSTRAINT `receipts_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `region_stock`
--
ALTER TABLE `region_stock`
  ADD CONSTRAINT `region_stock_ibfk_1` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `region_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `requisition`
--
ALTER TABLE `requisition`
  ADD CONSTRAINT `fk_requisition_assigned_cashier` FOREIGN KEY (`assigned_cashier_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `requisition_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `requisition_ibfk_4` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `requisition_ibfk_5` FOREIGN KEY (`recipient_id`) REFERENCES `user` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `requisition_amount_history`
--
ALTER TABLE `requisition_amount_history`
  ADD CONSTRAINT `req_amount_history_requisition_fk` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `req_amount_history_user_fk` FOREIGN KEY (`changed_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `requisition_item`
--
ALTER TABLE `requisition_item`
  ADD CONSTRAINT `requisition_item_ibfk_1` FOREIGN KEY (`requisition_id`) REFERENCES `requisition` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `retail_stock`
--
ALTER TABLE `retail_stock`
  ADD CONSTRAINT `retail_stock_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `retail_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);

--
-- Constraints for table `stock_adjustment`
--
ALTER TABLE `stock_adjustment`
  ADD CONSTRAINT `stock_adjustment_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `stock_adjustment_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `stock_adjustment_ibfk_3` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `stock_split`
--
ALTER TABLE `stock_split`
  ADD CONSTRAINT `stock_split_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `stock_split_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `stock_split_ibfk_3` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`);

--
-- Constraints for table `stock_transfer`
--
ALTER TABLE `stock_transfer`
  ADD CONSTRAINT `fk_stock_transfer_initiator` FOREIGN KEY (`initiator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_stock_transfer_operation_receiver` FOREIGN KEY (`operation_receiver_id`) REFERENCES `user` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_ibfk_1` FOREIGN KEY (`operation_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `stock_transfer_ibfk_2` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `stock_transfer_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`),
  ADD CONSTRAINT `stock_transfer_ibfk_4` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_ibfk_5` FOREIGN KEY (`main_stock_id`) REFERENCES `main_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_ibfk_6` FOREIGN KEY (`province_stock_id`) REFERENCES `province_stock` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `stock_transfer_region_fk` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `supplier_product`
--
ALTER TABLE `supplier_product`
  ADD CONSTRAINT `supplier_product_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `supplier` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `supplier_product_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `unpaid_invoices`
--
ALTER TABLE `unpaid_invoices`
  ADD CONSTRAINT `unpaid_invoices_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `unpaid_invoices_ibfk_1` FOREIGN KEY (`stock_manager_id`) REFERENCES `user` (`id`),
  ADD CONSTRAINT `unpaid_invoices_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `unpaid_invoices_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `user` (`id`);

--
-- Constraints for table `user`
--
ALTER TABLE `user`
  ADD CONSTRAINT `user_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`),
  ADD CONSTRAINT `user_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `user_ibfk_region` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `user_department`
--
ALTER TABLE `user_department`
  ADD CONSTRAINT `fk_user_department_department` FOREIGN KEY (`department_id`) REFERENCES `department` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_department_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_notification`
--
ALTER TABLE `user_notification`
  ADD CONSTRAINT `fk_notification_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_session`
--
ALTER TABLE `user_session`
  ADD CONSTRAINT `user_session_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wholesale_stock`
--
ALTER TABLE `wholesale_stock`
  ADD CONSTRAINT `wholesale_stock_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `province` (`id`),
  ADD CONSTRAINT `wholesale_stock_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
