<?php
include('../../includes/auth.php');
include('../../includes/header.php');
include('../../includes/functions.php');
include('../../config/database.php');

$conn = get_db_connection();
if (!$conn) {
    echo "<div class='alert alert-danger m-3'>Échec de la connexion à la base de données.</div>";
    include('../../includes/footer.php');
    exit;
}

// Determine role and province scope
$role_name = $_SESSION['role_name'] ?? ''; // assuming it's set in auth.php
$user_province_id = intval($_SESSION['province_id'] ?? 0);
$can_view_all = in_array($role_name, ['Admin','DG','DGA']);

// Read filters
$province_id = $can_view_all ? intval($_GET['province_id'] ?? 0) : $user_province_id;
if ($province_id <= 0) { $province_id = $user_province_id; }

$date = $_GET['date'] ?? date('Y-m-d'); // YYYY-MM-DD

// Current balance
$balance = 0.0;
$stmt = $conn->prepare("SELECT balance FROM province_cash_account WHERE province_id = ?");
$stmt->bind_param("i", $province_id);
$stmt->execute();
$stmt->bind_result($balanceValue);
if ($stmt->fetch()) {
    $balance = (float)$balanceValue;
}
$stmt->close();

// Opening balance (last running before day start)
$opening_balance = 0.0;
$stmt = $conn->prepare("
    SELECT running_balance
    FROM province_cash_transaction
    WHERE province_id = ? AND created_at < CONCAT(?, ' 00:00:00')
    ORDER BY created_at DESC, id DESC LIMIT 1
");
$stmt->bind_param("is", $province_id, $date);
$stmt->execute();
$stmt->bind_result($opening_balance_row);
if ($stmt->fetch()) { $opening_balance = floatval($opening_balance_row); }
$stmt->close();

// Closing balance (last running before next day)
$closing_balance = $opening_balance;
$stmt = $conn->prepare("
    SELECT running_balance
    FROM province_cash_transaction
    WHERE province_id = ? AND created_at < DATE_ADD(CONCAT(?, ' 00:00:00'), INTERVAL 1 DAY)
    ORDER BY created_at DESC, id DESC LIMIT 1
");
$stmt->bind_param("is", $province_id, $date);
$stmt->execute();
$stmt->bind_result($closing_balance_row);
if ($stmt->fetch()) { $closing_balance = floatval($closing_balance_row); }
$stmt->close();

// Transactions for the selected day
$txns = [];
$stmt = $conn->prepare("
    SELECT id, created_at, txn_type, direction, amount, reference_type, reference_id, description, running_balance
    FROM province_cash_transaction
    WHERE province_id = ? AND created_at >= CONCAT(?, ' 00:00:00') AND created_at < DATE_ADD(CONCAT(?, ' 00:00:00'), INTERVAL 1 DAY)
    ORDER BY created_at ASC, id ASC
");
$stmt->bind_param("iss", $province_id, $date, $date);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) { $txns[] = $row; }
$stmt->close();

// Province list for admin filters
$provinces = [];
if ($can_view_all) {
    $res = $conn->query("SELECT id, name FROM province ORDER BY name");
    while ($r = $res->fetch_assoc()) { $provinces[] = $r; }
}
?>
<div class="container mt-4">
    <h3 class="text-primary">Relevé de Caisse</h3>

    <form method="GET" class="card p-3 bg-light mb-3">
        <div class="row g-3">
            <?php if ($can_view_all): ?>
            <div class="col-md-4">
                <label class="form-label">Province</label>
                <select name="province_id" class="form-select" required>
                    <?php foreach ($provinces as $p): ?>
                        <option value="<?php echo (int)$p['id']; ?>" <?php echo ((int)$p['id']===$province_id?'selected':''); ?>>
                            <?php echo htmlspecialchars($p['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php else: ?>
                <input type="hidden" name="province_id" value="<?php echo (int)$province_id; ?>">
            <?php endif; ?>
            <div class="col-md-4">
                <label class="form-label">Date</label>
                <input type="date" name="date" value="<?php echo htmlspecialchars($date); ?>" class="form-control" required>
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button class="btn" style="background-color:#4B2F1F; color:#F4F0E4;">Afficher Relevé</button>
            </div>
        </div>
    </form>

    <div class="row g-3">
        <div class="col-md-4">
            <div class="card p-3" style="background:#F4F0E4;border-left:6px solid #4B2F1F;">
                <div>Solde d'Ouverture (<?php echo htmlspecialchars($date); ?>)</div>
                <div class="fw-bold fs-5"><?php echo number_format($opening_balance,2); ?> BIF</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card p-3" style="background:#F4F0E4;border-left:6px solid #4B2F1F;">
                <div>Solde de Clôture (<?php echo htmlspecialchars($date); ?>)</div>
                <div class="fw-bold fs-5"><?php echo number_format($closing_balance,2); ?> BIF</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card p-3" style="background:#F4F0E4;border-left:6px solid #4B2F1F;">
                <div>Solde Actuel (Maintenant)</div>
                <div class="fw-bold fs-5"><?php echo number_format($balance,2); ?> BIF</div>
            </div>
        </div>
    </div>

    <div class="card mt-3 p-3 bg-light">
        <h5>Transactions (<?php echo htmlspecialchars($date); ?>)</h5>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Heure</th>
                        <th>Type</th>
                        <th>Direction</th>
                        <th>Montant</th>
                        <th>Référence</th>
                        <th>Description</th>
                        <th>Solde Courant</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (empty($txns)): ?>
                    <tr><td colspan="7" class="text-muted">Aucune transaction trouvée.</td></tr>
                <?php else: foreach ($txns as $t): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($t['created_at']); ?></td>
                        <td><?php echo htmlspecialchars($t['txn_type']); ?></td>
                        <td><?php echo htmlspecialchars($t['direction']); ?></td>
                        <td><?php echo number_format((float)$t['amount'], 2); ?> BIF</td>
                        <td><?php echo htmlspecialchars($t['reference_type'] . ( $t['reference_id'] ? (' #' . $t['reference_id']) : '' )); ?></td>
                        <td><?php echo htmlspecialchars($t['description']); ?></td>
                        <td><?php echo number_format((float)$t['running_balance'], 2); ?> BIF</td>
                    </tr>
                <?php endforeach; endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include('../../includes/footer.php'); ?>
