<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$baseDir = '/opt/lampp/htdocs/masunzu_bar_hotel';
require_once $baseDir . '/includes/auth.php';
require_once $baseDir . '/config/database.php';
require_once $baseDir . '/includes/functions.php';

require_login();

$roleName = $_SESSION['role_name'] ?? '';
$allowedRoles = ['DG', 'DGA', 'Admin', 'Stock Manager'];
if (!in_array($roleName, $allowedRoles, true)) {
    header("Location: /masunzu_bar_hotel/dashboards/unauthorized.php");
    exit;
}

$conn = get_db_connection();
if (!$conn) {
    die("<p style='color:red;text-align:center;padding:20px;'>Connection failed.</p>");
}

$provinceId = $_SESSION['province_id'] ?? null;
$search = trim($_GET['search'] ?? '');
$statusFilter = trim($_GET['status'] ?? '');

$query = "
    SELECT 
        ui.id,
        ui.invoice_number,
        ui.customer_name,
        ui.paid_amount AS total_amount,
        ui.approval_status,
        ui.status,
        ui.is_loan_sale,
        ui.created_at,
        ui.paid_amount,
        u.full_name AS initiator,
        p.name AS province_name
    FROM unpaid_invoices ui
    LEFT JOIN user u ON ui.created_by = u.id
    LEFT JOIN province p ON ui.province_id = p.id
    WHERE 1=1
";
$params = [];
$types = '';
if ($search !== '') {
    $query .= " AND (ui.customer_name LIKE ? OR ui.invoice_number LIKE ? OR u.full_name LIKE ?)";
    $term = "%$search%";
    $params = array_merge($params, [$term, $term, $term]);
    $types .= 'sss';
}
if ($statusFilter !== '') {
    $query .= " AND ui.approval_status = ?";
    $params[] = $statusFilter;
    $types .= 's';
}
$normalizedRole = mbh_normalize_role_name($roleName);
if ($normalizedRole === 'Stock Manager' && $provinceId) {
    $query .= " AND ui.province_id = ?";
    $params[] = $provinceId;
    $types .= 'i';
}
$query .= " ORDER BY ui.created_at DESC LIMIT 200";

$stmt = $conn->prepare($query);
if ($stmt === false) {
    die("<p style='color:red;text-align:center;padding:20px;'>Database error: " . htmlspecialchars($conn->error) . "</p>");
}
if (!empty($types)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$orders = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

include $baseDir . '/includes/header.php';
?>
<div style="padding: 20px; background: #F4F0E4; min-height: 100vh; width: 100%; box-sizing: border-box;">
    <div style="width: 100%; margin: 0; background: #FFF; padding: 24px; border-radius: 12px; box-shadow: 0 12px 30px rgba(0,0,0,0.15); box-sizing: border-box;">
        <h1 style="color:#4B2F1F; font-size: 28px; margin-bottom: 10px;">Historique des Commandes</h1>
        <p style="color:#6D4C41; margin-bottom: 20px;">Filtrer, rechercher et consulter les commandes passées.</p>
        <form method="GET" style="display:flex; gap: 12px; flex-wrap:wrap; margin-bottom:20px;">
            <input type="text" name="search" value="<?php echo htmlspecialchars($search, ENT_QUOTES, 'UTF-8'); ?>" placeholder="Client, numéro ou initiateur..." style="flex:1; min-width: 200px; padding:10px 14px; border-radius:8px; border:1px solid #D7CCC8; font-size: 16px;">
            <select name="status" style="padding:10px 14px; border-radius:8px; border:1px solid #D7CCC8; font-size: 16px;">
                <option value="">Statut d'approbation</option>
                <option value="pending" <?php echo $statusFilter === 'pending' ? 'selected' : ''; ?>>En attente</option>
                <option value="approved" <?php echo $statusFilter === 'approved' ? 'selected' : ''; ?>>Approuvée</option>
                <option value="rejected" <?php echo $statusFilter === 'rejected' ? 'selected' : ''; ?>>Rejetée</option>
            </select>
            <button type="submit" style="background:#4B2F1F;color:#FFF;padding:10px 20px;border:none;border-radius:8px;font-weight:600;font-size: 16px;cursor:pointer;">Filtrer</button>
            <a href="orders_history.php" style="background:#6c757d;color:#FFF;padding:10px 20px;border:none;border-radius:8px;font-weight:600;font-size: 16px;text-decoration:none;display:inline-block;line-height:normal;">Réinitialiser</a>
        </form>
        <div style="overflow-x:auto;">
            <table style="width:100%; border-collapse:collapse;">
                <thead>
                    <tr style="background:#4B2F1F;color:#FFF;">
                        <th style="padding:12px;text-align:left;font-size: 16px;">Commande</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Client</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Auteur</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Dépôt</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Montant</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Créée le</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Statut Paiement</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Statut Approbation</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Type</th>
                        <th style="padding:12px;text-align:left;font-size: 16px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($orders)): ?>
                        <tr>
                            <td colspan="10" style="text-align:center;padding:20px;color:#6D4C41;font-size: 16px;">Aucune commande trouvée.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($orders as $order): ?>
                            <?php
                                $payment_status = $order['status'] ?? 'pending';
                                $is_loan = !empty($order['is_loan_sale']);
                                $approval_status = $order['approval_status'] ?? 'pending';
                                
                                // Payment status colors
                                $payment_status_color = '#FF9800'; // Orange for pending
                                $payment_status_text = 'En attente';
                                if ($payment_status === 'paid') {
                                    $payment_status_color = '#4CAF50'; // Green for paid
                                    $payment_status_text = 'Payé';
                                } elseif ($payment_status === 'unpaid') {
                                    $payment_status_color = '#DC3545'; // Red for unpaid
                                    $payment_status_text = 'Impayé';
                                }
                                
                                // Approval status colors
                                $approval_status_color = '#FF9800';
                                if ($approval_status === 'approved') {
                                    $approval_status_color = '#4CAF50';
                                } elseif ($approval_status === 'rejected') {
                                    $approval_status_color = '#DC3545';
                                }
                            ?>
                            <tr style="border-bottom:1px solid #EEE;">
                                <td style="padding:12px;font-size: 16px;">#<?php echo htmlspecialchars($order['invoice_number'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px;font-size: 16px;"><?php echo htmlspecialchars($order['customer_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px;font-size: 16px;"><?php echo htmlspecialchars($order['initiator'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px;font-size: 16px;"><?php echo htmlspecialchars($order['province_name'] ?? '—', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px;font-size: 16px;"><?php echo number_format((float)($order['total_amount'] ?? 0), 0, '.', ','); ?> BIF</td>
                                <td style="padding:12px;font-size: 16px;"><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($order['created_at'] ?? 'now')), ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px;font-size: 16px;">
                                    <span style="background-color:<?php echo $payment_status_color; ?>20;color:<?php echo $payment_status_color; ?>;padding:4px 8px;border-radius:4px;font-weight:600;font-size:14px;">
                                        <?php echo htmlspecialchars($payment_status_text, ENT_QUOTES, 'UTF-8'); ?>
                                    </span>
                                </td>
                                <td style="padding:12px;font-size: 16px;">
                                    <span style="background-color:<?php echo $approval_status_color; ?>20;color:<?php echo $approval_status_color; ?>;padding:4px 8px;border-radius:4px;font-weight:600;font-size:14px;">
                                        <?php echo ucfirst(htmlspecialchars($approval_status, ENT_QUOTES, 'UTF-8')); ?>
                                    </span>
                                </td>
                                <td style="padding:12px;font-size: 16px;">
                                    <?php if ($is_loan): ?>
                                        <span style="background-color:#9C27B0;color:#FFF;padding:4px 8px;border-radius:4px;font-weight:600;font-size:14px;">💰 Crédit</span>
                                    <?php else: ?>
                                        <span style="background-color:#2196F3;color:#FFF;padding:4px 8px;border-radius:4px;font-weight:600;font-size:14px;">💵 Espèces</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding:12px;font-size: 16px;">
                                    <a href="/masunzu_bar_hotel/modules/cashiers/view_invoice.php?id=<?php echo (int)$order['id']; ?>" style="background:#4B2F1F;color:#F4F0E4;padding:6px 12px;border-radius:6px;text-decoration:none;font-size:14px;font-weight:600;">Voir</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include $baseDir . '/includes/footer.php'; ?>
