<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Operation Manager role
if ($_SESSION['role_name'] !== 'Operation Manager') {
    error_log("Unauthorized access to orders.php by user {$_SESSION['full_name']} ({$_SESSION['role_name']})");
    header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
    exit;
}

// Fetch pending orders
$conn = get_db_connection();
if (!$conn) {
    die("Database connection failed");
}
$result = $conn->query("SELECT o.id, o.quantity, o.order_type, o.created_at, u.full_name AS agent_name, p.name AS province_name, pr.name AS product_name, pr.volume_cl FROM `order` o 
                       LEFT JOIN user u ON o.agent_id = u.id 
                       LEFT JOIN province p ON o.province_id = p.id 
                       LEFT JOIN product pr ON o.product_id = pr.id 
                       WHERE o.status = 'pending' ORDER BY o.created_at DESC");
$pending_orders = $result->fetch_all(MYSQLI_ASSOC);

// Handle approve/reject order
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_id'])) {
    $order_id = (int)$_POST['order_id'];
    $action = $_POST['action']; // 'approve' or 'reject'
    $status = $action === 'approve' ? 'approved' : 'rejected';
    $conn = get_db_connection();
    $stmt = $conn->prepare("UPDATE `order` SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $status, $order_id);
    $stmt->execute();
    $stmt->close();
    $conn->close();
    log_action($_SESSION['user_id'], $action . '_order', "$action order ID $order_id");
    header("Location: /masunzu_bar_hotel/modules/operation/orders.php");
    exit;
}
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div class="dashboard-container" style="padding: 20px; background-color: #F4F0E4; min-height: 70vh;">
    <div class="dashboard-header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; margin: 0;">Gestion des Commandes</h1>
        <a href="/masunzu_bar_hotel/modules/operation/order_history.php" style="background-color: #F4A261; color: #000000; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: bold;">Voir Historique</a>
    </div>
    <div class="dashboard-content" style="background-color: #FFFFFF; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
        <h2 style="color: #4B2F1F; margin-bottom: 20px;">Commandes en Attente</h2>
        <?php if (empty($pending_orders)): ?>
            <p style="color: #000000;">Aucune commande en attente.</p>
        <?php else: ?>
            <table style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                        <th style="padding: 10px; text-align: left;">ID</th>
                        <th style="padding: 10px; text-align: left;">Agent</th>
                        <th style="padding: 10px; text-align: left;">Province</th>
                        <th style="padding: 10px; text-align: left;">Produit</th>
                        <th style="padding: 10px; text-align: left;">Volume (cl)</th>
                        <th style="padding: 10px; text-align: left;">Quantité</th>
                        <th style="padding: 10px; text-align: left;">Type</th>
                        <th style="padding: 10px; text-align: left;">Créée</th>
                        <th style="padding: 10px; text-align: left;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pending_orders as $order): ?>
                        <tr style="border-bottom: 1px solid #F4F0E4;">
                            <td style="padding: 10px;"><?php echo htmlspecialchars($order['id']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($order['agent_name']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($order['province_name']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($order['product_name']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($order['volume_cl']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($order['quantity']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars(ucfirst($order['order_type'])); ?></td>
                            <td style="padding: 10px;"><?php echo date('Y-m-d H:i', strtotime($order['created_at'])); ?></td>
                            <td style="padding: 10px;">
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="order_id" value="<?php echo $order['id']; ?>">
                                    <button type="submit" name="action" value="approve" style="background-color: #008000; color: #F4F0E4; padding: 5px 10px; border: none; border-radius: 4px; cursor: pointer; margin-right: 5px;">Approuver</button>
                                </form>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="order_id" value="<?php echo $order['id']; ?>">
                                    <button type="submit" name="action" value="reject" style="background-color: #FF0000; color: #F4F0E4; padding: 5px 10px; border: none; border-radius: 4px; cursor: pointer;">Rejeter</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>